//
//  MCReportCenter.h
//  MCApplication
//
//  Created by Alykhan Jetha on Mon Jul 07 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import <AppKit/AppKit.h>
#import "MCQueryController.h"

#import "MCApplicationDefines.h"

@class MCTableviewController;

@interface MCReportCenter : MCQueryController {

	IBOutlet	MCTableviewController		*reportGroupTVC;
	IBOutlet	MCTableviewController		*reportDefinitionTVC;
	
	IBOutlet	NSPopUpButton				*reportOutputTypePop;	// ascii or pdf
	IBOutlet	NSTabView					*reportOutputTypeTabView;
	
	IBOutlet	NSTextField					*customMappingNameField;
	IBOutlet	NSButton					*customMappingBrowseButton;	
	
	IBOutlet	NSPopUpButton				*reportLayoutTypePop;
	IBOutlet	NSPopUpButton				*factoryLayoutNamePop;
	IBOutlet	NSTabView					*factoryCustomTabView;
	IBOutlet	NSTextField					*customLayoutNameField;
	IBOutlet	NSButton					*customLayoutBrowseButton;
	
	IBOutlet	NSPopUpButton				*reportDestinationTypePop; // email, print, save
	IBOutlet	NSProgressIndicator			*reportProgressIndicator;
	IBOutlet	NSButton					*runReportButton;

        IBOutlet	NSTextField				*outputToTextField;
	id										_currentQueryProcessor;
	id										_currentPostQueryProcessor;
	
	id										_currentResult;

}

/*!

	REPORTS = (
		{
		REPORT_GROUP = "Activity";
		REPORT_NAME = "Contact Activity Report";
		REPORT_UNIQUE_IDENTIFIER = @"ContactActivityReport2";
		CRITERIAS = (
			{MENU_TITLE = "Assigned To"; QUALIFIER_TYPE = "GWUserQualifierView"; LABEL = "Assigned To"; KEY_PATH = ""; MANDATORY = YES;},
			{MENU_TITLE = "Name"; QUALIFIER_TYPE = "MCStringQualifierView"; LABEL = "Name"; KEY_PATH = "cachedName"; },
			{MENU_TITLE = "Electronic"; QUALIFIER_TYPE = "MCStringQualifierView"; LABEL = "Electronic"; KEY_PATH = "electronicAddresses.url"; },
			{MENU_TITLE = "City"; QUALIFIER_TYPE = "MCStringQualifierView"; LABEL = "City"; KEY_PATH = "geoAddresses.city"; },
			{MENU_TITLE = "State / Province"; QUALIFIER_TYPE = "MCStringQualifierView"; LABEL = "State/Prov."; KEY_PATH = "geoAddresses.state"; },
			{MENU_TITLE = "Country"; QUALIFIER_TYPE = "MCStringQualifierView"; LABEL = "Country"; KEY_PATH = "geoAddresses.country"; },

		);
		
		ALLOWS_TEXT_OUTPUT = 1;
		ALLOWS_PDF_OUTPUT = 1;
		
		ALLOWS_TEXT_CUSTOM_MAPPING = 1;
		TEXT_CUSTOM_MAPPING_EXTENSION = plist;
		
		FACTORY_LAYOUTS = (
			{HUMAN_READABLE_NAME = Standard; SOURCE_TYPE = file; SOURCE_NAME = "myReport"; SOURCE_EXTENSION = "dwdoc"; SOURCE_LOCATION = bundle; IN_BUNDLE_OF_CLASSNAMED = "AClassName";},
			);

		CAN_CHOOSE_CUSTOM_LAYOUT = 1;
		CUSTOM_LAYOUT_EXTENSION = dwdoc;
		CUSTOM_LAYOUT_MASTERENTITY = Contact;

		QUERY_PROCESSOR_CLASSNAME = "ActivityQueryProcessor";
		POST_QUERY_PROCESSOR_CLASSNAME = "ReportCenter";

		
		},
		
	)


*/

/*!
	@method +lazilyRegisterReportsFromContentsOfFile:
	@discussion records the given path and only reads content when actually needed. Report definitions may be very large so we do not want to bog down the launch of the app.
*/
+ (void)lazilyRegisterReportsAtPath:(NSString *)aFullPath;
+ (void)loadLazilyRegisteredReports;

+ (void)addReportsFromContentsOfFile:(NSString *)path;
+ (void)addReportsFromDictionary:(NSDictionary *)dict;

+ (void)registerReportDefinition:(NSDictionary *)dict forReportGroup:(NSString *)groupname;


+ (NSArray *)reportGroups;
+ (NSArray *)reportDefinitionsForReportGroup:(NSString *)groupname;

+ (MCReportCenter *)defaultReportCenter;

- (void)setCurrentResult:(id)aResult;
- (id)currentResult;

- (NSString *)defaultsNameForCurrentReport;

- (NSDictionary *)readDefaultsForCurrentReport;
- (void)writeDefaultsForCurrentReport;

- (void)configureOutputTypeWithOptionalDefaults:(NSDictionary *)defs;
- (void)configureLayoutTypeWithOptionalDefaults:(NSDictionary *)defs;

- (void)configureFactoryLayoutsWithOptionalDefaults:(NSDictionary *)defs;
- (void)configureCustomLayoutLastEntryWithOptionalDefaults:(NSDictionary *)defs;
- (void)configureCustomMappingLastEntryWithOptionalDefaults:(NSDictionary *)defs;


- (NSString *)choosenOutputType;
- (NSString *)choosenLayoutAbsoluteLocation;
- (NSString *)choosenDestinationType;

- (IBAction)browseForCustomMapping:(id)sender;
- (IBAction)browseForCustomLayout:(id)sender;

- (IBAction)runReport:(id)sender;

- (void)clearCurrentQueryProcessor;
- (void)queryProcessor:(id)aProcessor 
	didCompleteWithCode:(MCQueryProcessorCompletionCode)aCode;

- (void)clearCurrentPostQueryProcessor;
- (void)postQueryProcessor:(id)aPostProcessor 	didCompleteWithCode:(MCQueryPostProcessorCompletionCode)aCode;


@end

@interface NSDocument (ReportAdditions)

- (IBAction)showReportCenter:(id)sender;

@end

